//This code has the mode select commented out as well as the slider code
//The result is a faster joysticks code. There's a delay function that we use to
// slow the movemement of the arm down.
// Idle is also set at 100 which probably needs adjusting to stop the servos timing out so quickly.

#include <Servo.h> 
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>

// Hardware SPI (faster, but must use certain hardware pins):
// SCK is LCD serial clock (SCLK) - this is pin 13 on Arduino Uno
// MOSI is LCD DIN - this is pin 11 on an Arduino Uno
// pin 4 - Data/Command select (D/C)
// pin 8 - LCD chip select (CS)
// pin 7 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 8, 7);//updated MeArm Pins
// Note with hardware SPI MISO and SS pins aren't used but will still be read
// and written to during SPI transfer.  Be careful sharing these pins!

#define XPOS 0
#define YPOS 1

const int SERVOS = 4;
const int ACC = 10; // the accurancy of the potentiometer value before idle starts counting
int PIN[SERVOS], value[SERVOS], idle[SERVOS], currentAngle[SERVOS], currentCoord[SERVOS], CooMIN[SERVOS], CooMAX[SERVOS], MIN[SERVOS], MAX[SERVOS], INITANGLE[SERVOS], previousCoord[SERVOS], ANA[SERVOS];
Servo myservo[SERVOS];
//int modePin = 3;
//int mode = LOW; // mode stores button push to change between Joysticks and Sliders

#define LOGO16_GLCD_HEIGHT 16
#define LOGO16_GLCD_WIDTH  16

// This section of constants is for the Inverse Kinematics Bit
const float pi = 3.14159;
// Arm Measurements
const int bicep = 81; // bicep length in mm
const int forearm = 81; // forearm length in mm
const int base = 60; // base height in mm
/* some stuff to help later on */
float for_sq = forearm*forearm;
float bic_sq = bicep*bicep;
/* these are used in the equations more than the actual lengths */

void setup()   {
  Serial.begin(57600);
//  int mode = LOW; 
//  pinMode(modePin, INPUT); // Enables button for Mode Change on Startup
  display.begin();
  // init done
  // you can change the contrast around to adapt the display
  // for the best viewing!
  display.setContrast(60);
  display.display(); // show splashscreen
  display.clearDisplay(); 
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
//  display.println("To Use Sliders");
//  display.println("Hold Right Button");
//  display.println("Else");
  display.println("Hello!");
  display.println(" ");
  display.println(" ");
  display.println(" ");
  display.println(" ");
  display.println("from MeArm.com");
  display.display(); // show splashscreen
  delay(5000);
  display.clearDisplay();   // clears the screen and buffer

  

  //Middle Servo
  PIN[0] = 10;
  MIN[0] = 0;
  MAX[0] = 180;
  INITANGLE[0] = 90;
  ANA[0] = 1;
  //Left Side
  PIN[1] = 9;
  MIN[1] = 60; // This should bring the lever to just below 90deg to ground
  MAX[1] = 165;
  INITANGLE[1] = 152; // This should bring the lever parallel with the ground
  ANA[1] = 0;
  //Right Side
  PIN[2] = 6;
  MIN[2] = 40;
  MAX[2] = 180;
  INITANGLE[2] = 90;
  ANA[2] = 2;
  //Claw Servo
  PIN[3] = 5;
  MIN[3] = 60;
  MAX[3] = 180;
  INITANGLE[3] = 60;
  ANA[3] = 3;

// These are the Coordinate MinMax for IK
// We use them to set the field of movement available
  CooMIN[0] = 0; //Theta
  CooMAX[0] = 180;
  CooMIN[1] = 60; //R
  CooMAX[1] = 210;
  CooMIN[2] = -45; //Z
  CooMAX[2] = 130;
  CooMIN[3] = 0; //Gripper
  CooMAX[3] = 180;
  
  for (int i = 0; i < SERVOS; i++){
    myservo[i].attach(PIN[i]);
    myservo[i].write(INITANGLE[i]);
    value[i] = 0;
    idle[i] = 0;
    currentCoord[i] = // calculate initial values by reworking eq?
    previousCoord[i]=INITANGLE[i];
    
  }
}

void loop() {
  delay(5); // Delay function to slow movement of arm down

    for (int i = 0; i < SERVOS; i++){ // Loop runs through inputs to see if any are moving
      value[i] = analogRead(ANA[i]);
      currentAngle[i] = myservo[i].read();
      
      if (value[i] > 612) {
        idle[i] = 0;      
        if (currentCoord[i] < CooMAX[i]) ++currentCoord[i];
      } else if (value[i] < 212) {
        idle[i] = 0;
        if (currentCoord[i] > CooMIN[i]) --currentCoord[i];
      } else {
        ++idle[i];
      }
      if (idle[i] > 100){
        myservo[i].detach();
        idle[i] = 0;
      }  
  }  
  
   int b = sqrt ((currentCoord[1] * currentCoord[1]) + (currentCoord[2] * currentCoord[2]));        // b = distance from the origin to the start of the gripper
   //Serial.write(b);
  float q1 = atan2( currentCoord[1], currentCoord[2] );                // q1 = angle between the horizontal and the line b
   //Serial.print(q1,4);
   float q2 = acos((bic_sq - for_sq + (b * b))/(2 * bicep * b)); // q1 = angle between line b and the bicep
  //Serial.print(q2,4);
   float abi = q1 + q2;                     // abi = angle between horizontal and the bicep
  //Serial.print(abi,4);
   float afo = acos((bic_sq + for_sq - (b * b))/(2 * bicep * forearm)); // afo = angle between bicep and forearm
  // Also convert from Radians to degrees
   abi = 180 - (abi * 57.3);
   afo = (afo * 57.3);

  for (int i = 0; i < SERVOS; i++){
    if(i == 0 || i == 3) {
      if (currentCoord[i] != previousCoord[i]) {
       if (!myservo[i].attached()){
          myservo[i].attach(PIN[i]);
       }
       currentAngle[i] = currentCoord[i];
       myservo[i].write(currentAngle[i]);
       previousCoord[i] = currentCoord[i];
      }
   } else if ( i == 1) {
    if (currentCoord[i] != previousCoord[i]) {
       if (!myservo[i].attached()){
          myservo[i].attach(PIN[i]);
       }
       currentAngle[i] = abi;
       myservo[i].write(currentAngle[i]);
       previousCoord[i] = currentCoord[i];
   } else if ( i == 2) {
    if (currentCoord[i] != previousCoord[i]) {
       if (!myservo[i].attached()){
          myservo[i].attach(PIN[i]);
       }
       currentAngle[i] = afo;
       myservo[i].write(currentAngle[i]);
       previousCoord[i] = currentCoord[i];
     }
    }
   }
  }
   
//  Serial.print(currentAngle[0]);
//  Serial.print(" ; ");
//  Serial.print(currentAngle[1]);
//  Serial.print(" ; ");
//  Serial.print(currentAngle[2]);
//  Serial.print(" ; ");
//  Serial.println(currentAngle[3]);
  
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
 // display.print("Middle at ");
  display.print(currentAngle[0]);
//  display.println((char)247); //LCD Code
//  display.print("Left at ");
  display.print(currentAngle[1]);
 // display.println((char)247); //LCD Code
//  display.print("Right at ");
  display.print(currentAngle[2]);
 // display.println((char)247); //LCD Code
 // display.print("Claw at ");
  display.print(currentAngle[3]);
  display.println((char)247); //LCD Code
//  display.println("MeArm Robot");
//  display.println(idle[1]);
  
//  Display Potentiometer Values on LCD (Slows MeArm Down too)
  display.print(value[0]);
  display.print(";");
  display.print(value[1]);
  display.print(";");
  display.print(value[2]);
  display.print(";");
  display.println(value[3]);
  
  display.print(currentCoord[0]);
  display.print(";");
  display.print(currentCoord[1]);
  display.print(";");
  display.print(currentCoord[2]);
  display.print(";");
  display.println(currentCoord[3]);
  
  display.print(idle[0]);
  display.print(";");
  display.print(idle[1]);
  display.print(";");
  display.print(idle[2]);
  display.print(";");
  display.println(idle[3]);
  
  display.print(abi);
  display.print(";");
  display.println(afo);
  display.display();
  
}



/*********************************************************************
This is an example sketch for our Monochrome Nokia 5110 LCD Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/338

These displays use SPI to communicate, 4 or 5 pins are required to
interface

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/